#ifndef _HEADERS_FUNCTIONS_H
#define _HEADERS_FUNCTIONS_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FatalError(char *xMessage)
{
    MessageBox(GetActiveWindow(), xMessage, TitleCaption, MB_ICONHAND + MB_SYSTEMMODAL);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void WriteLog(char *xMessage)
{
    fprintf(gfSessionLog, "%s\r\n", xMessage);
    InsertListBoxItem(SDI.ServerList_hWnd, xMessage, -1);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool xMainEntry(void)
{
    if(!Initialize())
        return false;

    if(!StartServer())
    {
        WriteLog("Error starting server.");
    }

    while(!gbKillApplication)
    {
        Sleep(1);
    }

    if(!StopServer())
    {
        WriteLog("Error stopping server.");
    }

	return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool KillApplication(void)
{
    gbKillApplication = true;

    StopServer();

    Sleep(1000);

    if(!Uninitialize())
        return false;

    return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void CreateFolderStructure(char *FullFileName)
{
    char Directory[256];

    int NameLength = strlen(FullFileName);
    int Position = 0;

    while(Position < NameLength)
    {
        if(FullFileName[Position] == '\\' || FullFileName[Position] == '/')
        {
            Directory[Position] = '\0';
            CreateDirectory(Directory, NULL);
        }

        Directory[Position] = FullFileName[Position];

        Position++;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ServerSend(int Client, char *String, int Length)
{
    while( !MyServer.SetSendDataEx(Client, String, Length) && MyServer.Connected[Client] )
        Sleep(1);

    return MyServer.Connected[Client];
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool SimpleServerSend(int Client, char *Text)
{
    return ServerSend(Client, Text, strlen(Text));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool StartServer(void)
{
    if(MyServer.Start(glListenPort))
    {
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_START, MF_GRAYED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_STOP, MF_ENABLED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_SETTINGS, MF_GRAYED);

        return true;
    }
    else{
        WriteLog("Failed to start server.");
        return false;
    }

    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool StopServer(void)
{
    if(MyServer.Stop())
    {
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_START, MF_ENABLED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_STOP, MF_GRAYED);
        EnableMenuItem(SDI.Menu_hWnd, ID_SERVER_SETTINGS, MF_ENABLED);

        return true;
    }
    else{
        WriteLog("Failed to stop server.");
        return false;
    }

    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool GetRegistryValues(void)
{
	DWORD SizeofString = 0;

    SizeofString = sizeof(gsSessionLogDir);
	memset(gsSessionLogDir, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SessionLogDir", gsSessionLogDir, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexServer);
	memset(gsSQLIndexServer, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexServer", gsSQLIndexServer, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexUserID);
	memset(gsSQLIndexUserID, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexUserID", gsSQLIndexUserID, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexPassword);
	memset(gsSQLIndexPassword, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexPassword", gsSQLIndexPassword, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexDatabase);
	memset(gsSQLIndexDatabase, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexDatabase", gsSQLIndexDatabase, SizeofString))
        return false;

    SizeofString = sizeof(gsSQLIndexDriver);
	memset(gsSQLIndexDriver, 0, SizeofString);
    if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "SQLIndexDriver", gsSQLIndexDriver, SizeofString))
        return false;

    if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "MaxConnections", (DWORD &) giMaxConnections))
        return false;

	if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "TCPLoopDelay", glTCPLoopDelay))
        return false;

    if(!Get_DWORDRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "ListenPort", glListenPort))
        return false;

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

